RECURSIVE FUNCTION fact(n) RESULT(answer)
!
!  Purpose:
!    To calculate the factorial function
!             | n(n-1)!    n >= 1 
!       n ! = |
!             | 1          n = 0
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    10/31/95    S. J. Chapman        Original code
!
IMPLICIT NONE

! List of calling arguments:
INTEGER, INTENT(IN) :: n         ! Value to calculate
INTEGER :: answer                ! Result variable

IF ( n >= 1 ) THEN
   answer = n * fact(n-1)
ELSE
   answer = 1
END IF

END FUNCTION fact
